// mQpHQqlgZrhJraGX1PGB1F40kf9azojPaO5MSIMbfrQ13ZlQy8hORvQUOORA3JHcf7RwoHSUu096qg3Xzf+M+YnCXNZ+LjXx1ephfbSVrx6l3iYirxQkDern6HGf025pZ0LioW+TTY4ilHI79i+834266CiGM6mFv5UCMUB45RSTlEJWgAq48YkycRhMPyG6XjO+XatwoFoG4Awz3STJXFxC+5lyH8ikc7538lMEUkLHcOcPZt4giZOpnLHlvpPBhNKmR8ZNc90o+mItCG4PJ8Ar69LKF7jWSHxwjZmbMVcv86duiiRy51J7+C8LwdVnKp8xzhzag2rdvjx/nAIwTw==
/**
** Copyright (C) 2000-2010 Opera Software AS.  All rights reserved.
**
** This file is part of the Opera web browser.
**
** This script patches sites to work better with Opera
** For more information see http://www.opera.com/docs/browserjs/
**
** If you have comments on these patches (for example if you are the webmaster
** and want to inform us about a fixed site that no longer needs patching) please
** report issues through the bug tracking system
** https://bugs.opera.com/
**
** DO NOT EDIT THIS FILE! It will not be used by Opera if edited.
**/
// Generic fixes (mostly)
(function(opera){
	if(!opera || (opera&&opera._browserjsran))return;
	if(opera)opera._browserjsran=true;
	var bjsversion=' Opera Linux SDK 2560, March 15, 2010 ';
	// variables and utility functions
	var navRestore = {}; // keep original navigator.* values
	var shouldRestore = false;
	var hostname = location.hostname; // caching some strings for performance
	var href = location.href;
	var pathname=location.pathname;
	var fixed = false; // magic fixes need only run once
	if(!opera.postError)opera.postError=function(){}; // handling versions w/o error console
	// Storing function references
	var postError = opera.postError,
	call = Function.prototype.call,
	indexOf=String.prototype.indexOf,
	lastIndexOf=String.prototype.lastIndexOf,
	replace=String.prototype.replace,
	match=String.prototype.match,
	toLowerCase=String.prototype.toLowerCase,
	getAttribute=Element.prototype.getAttribute,
	setAttribute=Element.prototype.setAttribute,
	insertBefore=Node.prototype.insertBefore,
	insertAdjacentHTML=Element.prototype.insertAdjacentHTML,
	defineMagicVariable=opera.defineMagicVariable,
	defineMagicFunction=opera.defineMagicFunction,
	version=opera.version,
	getElementById=Document.prototype.getElementById,
	appendChild=Node.prototype.appendChild,
	removeChild=Node.prototype.removeChild,
	replaceChild=Node.prototype.replaceChild,
	evaluate=Document.prototype.evaluate,
	getElementsByTagName=Document.prototype.getElementsByTagName,
	createElement=Document.prototype.createElement,
	createTextNode=Document.prototype.createTextNode,
	stopPropagation=Event.prototype.stopPropagation,
	preventDefault=Event.prototype.preventDefault,
	getComputedStyle=window.getComputedStyle,
	slice=Array.prototype.slice,
	shift=Array.prototype.shift,
	setTimeout=window.setTimeout,
	removeAttribute=Element.prototype.removeAttribute,
	addEventListener=Document.prototype.addEventListener,
	isNaN=window.isNaN,
	RegExp=window.RegExp,
	unescape=window.unescape,
	func_toString=Function.prototype.toString,
	parseFloat=window.parseFloat,
	random=Math.random;
	var opera_version = parseFloat.call(window,opera.version());

	// Utility functions

	function addCssToDocument(cssText, doc, mediaType){
		getElementsByTagName.call=addEventListener.call=createElement.call=createTextNode.call=insertBefore.call=setAttribute.call=appendChild.call=version.call=call;
		doc = doc||document;
		mediaType = mediaType||'';
		addCssToDocument.styleObj=addCssToDocument.styleObj||{};
		var styles = addCssToDocument.styleObj[mediaType];
		if(!styles){
			var head = getElementsByTagName.call(doc, "head")[0];
			if( !head ){
				var docEl = getElementsByTagName.call(doc, "html")[0];
				if(!docEl){
					// :S this shouldn't happen - see if document hasn't loaded
					addEventListener.call(doc, opera&&version.call(opera)>=9?'DOMContentLoaded':'load',
					function(){ addCssToDocument(cssText, doc); },false);
					return;
				}
				head = createElement.call(doc, "head");
				if(head) insertBefore.call(docEl, head,docEl.firstChild);
				else head = docEl;
			}
			addCssToDocument.styleObj[mediaType] = styles = createElement.call(doc, "style");
			setAttribute.call(styles, "type","text/css");
			if(mediaType)setAttribute.call(styles, "media", mediaType);
			appendChild.call(styles, createTextNode.call(doc,' '));
			appendChild.call(head, styles)
		}
		styles.firstChild.nodeValue += cssText+"\n";
		return true;
	}

	function addPreprocessHandler( search, replacement, onceonly, conditional ){
		// adding event handler for script pre-processing if required
		opera.addEventListener('BeforeScript', 
			function(e){ 
				indexOf.call=replace.call=removeEventListener.call=call; /* also needs anything used inside conditional! */
				if( conditional && ! conditional(e.element) ){return;}
				e.element.text=replace.call( e.element.text, search, replacement );
				if(onceonly){
					removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
				}
			}
		, false);
	}

function avoidDocumentWriteAbuse(contentRegexp){
	var dw=document.write;
	contentRegexp = contentRegexp || /(^<img .*?width=("|)1("|)\s+height=("|)1("|)\s+border=("|)0("|)\s+alt="".*?>$|^\[object Object\]$)/i;
	document.write=function( s ){
		if( String(s).match( contentRegexp ) ){
			opera.postError('Warning: scripts on '+window.location+' were changed by the s_code patch. See browser.js for details.');
		}else{//opera.postError(arguments);
			dw.apply(document, arguments);
		}
	};
}
function avoidMagicBodyCreation(){
	document.createElement=(function(createElement){
		var tmpDoc = document.implementation.createDocument('http://www.w3.org/1999/xhtml/', 'html', null);
		return function(tagName){
			if( ! document.body ){
				return createElement.call( tmpDoc, tagName );
			}else{
				document.createElement=createElement; // this hack is not necessary anymore
				return createElement.call(this, tagName);
			}
		}
	})(document.createElement);
}
	function fakeCSSFilters(){ // faking support for some of the common filters so that using them won't stop the script
		var filterObj={apply:function(){}, play:function(){}, Apply:function(){}, Play:function(){}}; // some of the common functions
		HTMLElement.prototype.filters=[ filterObj, filterObj, filterObj ]; // fake three applied filters with play and apply functions
		HTMLElement.prototype.filters['blendTrans']=filterObj; // we also fake a named blendTrans filter
	}

	function fixCoolmenus(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
		// Version 4 is Opera 7 - compatible and does user agent sniffing
		navRestore['userAgent'] = navigator.userAgent;
		navigator.userAgent +=' msie 6';
		shouldRestore = true;
		defineMagicVariable.call(opera, 'bw', function(o){
			// we need to override yet some more browser detection, and disable CSS filters
			// usedom must be 0 to make frameset menus work
			o.filter=o.op7=o.op=o.usedom=o.ns6=0;
			o.ie=o.ie6=1;
			return o}, function(o){return o});
		addPreprocessHandler(  'this.win.document.body.appendChild(oNS)',  'try{this.win.document.body.appendChild(oNS)}catch(e){oNS=this.win.document.body.appendChild(this.win.document.importNode(oNS, true))}' );
		addPreprocessHandler(  'oNS.appendChild(oNS2)',  'try{oNS.appendChild(oNS2);}catch(e){oNS2=oNS.appendChild(oNS.document.importNode(oNS2, true));}' );
	}

	function fixHVMenu(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=match.call=call;
		// fix by changing Opera from an unsupported browser to a supported browser
		// Set to true either PosStrt, NavYes, DomNav   or   PosStrt, ExpYes, DomExp
		defineMagicVariable.call(opera, 'PosStrt', function(){ return true }, null);
		defineMagicVariable.call(opera, 'NavYes', function(){ return true }, null);
		defineMagicVariable.call(opera, 'DomNav', function(){ return true }, null);
		// if Opera >= 9.5, load events are sent to document and not to body - make sure script doesn't set body.onload
		defineMagicVariable.call(opera, 'Trigger', function(){ return document; }, null);
		// Tell the script that CSS filters are not supported.
		defineMagicVariable.call(opera, 'Fltr', function(){ return false; }, function(){ return });
		// More recent versions look for 'opera 7' in navigator.userAgent and some do not use the variable names above
		if(  match.call(name, /var\.js$/) || match.call(name, /compact\.js$/) ){
			navRestore['userAgent'] = navigator.userAgent;
			navigator.userAgent+=' opera 7'; 
			shouldRestore = true;
		}
	}
	function fixHierMenus(){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
	      // HM_IsMenu must be true to make the menu appear
	      // HM_BrowserString should be DOM to make the right library load
		defineMagicVariable.call(opera, 'HM_IsMenu', function(){ return true}, function(){ return true });
		if(!document.all)defineMagicVariable.call(opera, 'HM_IE', function(){ return true}, function(){ return true });
		defineMagicVariable.call(opera, 'HM_BrowserString', function(){ return 'DOM'}, function(){ return 'DOM' });
		if(HTMLBodyElement.prototype.__defineGetter__)HTMLBodyElement.prototype.__defineGetter__('clientHeight', function(){return this.ownerDocument.documentElement.clientHeight;}); // PATCH-33
	}

function fixIFrameSSIscriptII(name, iFrameId){
	if(typeof name==='string'&&!arguments.callee.name)opera.defineMagicFunction(name, function (a,b,frameid){
		frameid = frameid|| iFrameId;
		var currentfr=document.getElementById(frameid);
		if (currentfr){
			currentfr.height = currentfr.contentDocument.documentElement.scrollHeight;
			if(!arguments.callee._listenerAdded){
				currentfr.addEventListener("load", arguments.callee, false);
				arguments.callee._listenerAdded=true;
			}
		}
	});
	fixIFrameSSIscriptII[name]=1;//remember that we fixed this already
}
function fixLiknoAllWebMenus(ev){
	indexOf.call=match.call=defineMagicVariable.call=postError.call=removeEventListener.call=appendChild.call=createElement.call=preventDefault.call=replace.call=call;
	if(fixed)return; fixed=true;
	if( indexOf.call(ev.element.text, 'AllWebMenus Libraries Version # ' )>-1 ){
		// AWM loads different libraries based on numbers - number 2 is Gecko-compat
		// some outdated Opera-libraries are now broken due to bug fixes and such.
		var awmVersion = parseInt(match.call(ev.element.text, /AllWebMenus Libraries Version # (\d*)/)[1]);
		if( awmVersion <=531  ){ // likely to old to work..
			defineMagicVariable.call(opera,   'scriptNo', function(){return 2}, null);
			defineMagicVariable.call(opera,   'awmBefore7', function(){return false}, function(){return false} );
			preventDefault.call(ev); // don't run this script
			var script = appendChild.call(document.body, createElement.call(document, 'script')); // create another one..
			script.src = replace.call(ev.element.src, /awmlib\d*\.js/, 'awmlib2.js'); // and load a more suitable version
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AllWebMenus fix). See browser.js for details.');
		}
		removeEventListener.call(opera, 'BeforeScript', arguments.callee, false );
	}
}
	function fixMilonicMenu(name){ 	// gotcha: must be called with script.src as argument
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=defineMagicFunction.call=addEventListener.call=call;
	      // "opera" or "opra" true will cause no menu or garbled (Opera 6 pixel* -  compat)
		defineMagicVariable.call(opera, 'opera', function(){ return false }, function(){});
		defineMagicVariable.call(opera, 'opra', function(){ return false }, function(){});
		// ie55 true will use IFRAME shims
		defineMagicVariable.call(opera, 'ie55', function(){ return false }, function(){ });
		// identifying as Opera will cause "dom" variable to be false in some versions
		defineMagicVariable.call(opera,  'dom' , function(){ return true }, function(){});
		// fixForm function will hide page content
		defineMagicFunction.call(opera,  'fixForm' , function(){});
		// Menu does not work on Mac if it detects platform
		defineMagicVariable.call(opera, 'mac', function(){ return false }, function(){ });
		// bug 330958
		if(!window.scrollX){
			opera.defineMagicVariable('scrollY', function(){ return document.body.scrollTop;}, null);
			opera.defineMagicVariable('scrollX', function(){ return document.body.scrollLeft;}, null);
		}
	}

function fixOpenCube(name){// IMPORTANT gotcha: the fixOpenCube and fixHVMenu functions must be called with an appropriate string argument
	if(fixed)return;
	match.call=addEventListener.call=defineMagicVariable.call=indexOf.call=call;
	// OpenCube menu
	window.vxml = window.vxml||{}; // to fix semi-opera-detection
	//Some versions try to call a function q99 which is only defined in the Opera library
	addEventListener.call(window, 'load', function(){ if(typeof q99=='undefined')window.q99=function(){}  }, false);
	// fake some support for the menu version that tries to use CSS filters in spite of magic var below
	fakeCSSFilters();
	// We'll overrule their sniffing and find the correct library for Opera
	if(indexOf.call(navigator.appVersion, 'Mac')!=-1){
		// They don't seem to like Macs.. see 356184
		navigator.appVersion = replace.call( navigator.appVersion, 'Mac', 'M A C' );
		addEventListener.call(opera, 'AfterExternalScript', function(){
			replace.call = removeEventListener.call = call;
			navigator.appVersion = replace.call( navigator.appVersion, 'M A C', 'Mac' );
			removeEventListener.call(opera, 'AfterExternalScript', arguments.callee, false);
		}, false);
		// some variables are uninitialized
		q20=q21=[];
	}
	if(match.call(name, /dqm_script\d*\.js$/)){
		defineMagicVariable.call(opera, 'brn', function(val){ return 'ie' }, function(val){ return 'ie' });
		defineMagicVariable.call(opera, 'ie6', function(val){ return true }, function(val){ return true });
		// prevent the menu from trying to use CSS filters
		defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);
		if(document.evaluate){ // we have an event transparency problem on some sites, see for example bug 239622
			addEventListener.call(window, 'load', function(){
				var nodes=document.evaluate( '//a/child::img[substring(@id, 0, 4)=\'qmim\']', document.body,null,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null ),node;
				while( node=nodes.iterateNext()){
					node.parentElement.parentElement.replaceChild(node, node.parentElement );
				};
			}, false);
		}
		fixed=true;
		return true;
	}else if(indexOf.call(name, 'dqm_loader.js')>-1){
		defineMagicVariable.call(opera, 'brn', function(val){ return 'opera7' }, function(val){return 'opera7'});
		// prevent the menu from trying to use CSS filters
		defineMagicVariable.call(opera, 'DQM_sub_menu_effect',  function(){return 'none';}, null);
		fixed=true;
		return true;
	}else if(indexOf.call(name, 'dnm_script.js')>-1){ // very old version.. 153257
		defineMagicVariable.call(opera, 'ie5', function(val){ return true }, function(val){ return true });
		defineMagicVariable.call(opera, 'ns5', function(val){ return true }, function(val){ return true });
	}
}

	function fixSoThinkMenus(){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=addEventListener.call=call;
		defineMagicVariable.call(opera, 'nOP',function(){return false;},null);
		defineMagicVariable.call(opera, 'nIE',function(){return false;},null);
		defineMagicVariable.call(opera, 'nNN6',function(){return true;},null);
		addEventListener.call(window, 'load', function(e){ if(window.st_onload)st_onload(e); }, false );//PATCH-55
	}

	function fixTransmenus(){
		// Fixing bugs in menu script from http://www.youngpup.net/2004/transmenus/ 
		// Credits xErath and Andrew Gregory
		opera.addEventListener('BeforeScript', function(ev) {
			indexOf.call=replace.call=removeEventListener.call=call;
			var js = ev.element.text;
			if (indexOf.call(js, "TransMenu")!=-1) {
				js = replace.call(js, /return\s+r(\b)/,"return true$1");
				js = replace.call(js, /mac/g,"xpto");
				js = replace.call(js, "el.scrollLeft", "0");
				js = replace.call(js, "el.scrollTop", "0");
				ev.element.text = js;
				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
			}
		}, false);
	}

	function fixUDM(name){
		if(fixed){return;}fixed=true;
		defineMagicVariable.call=call;
		// If the menu is a 3.x version we would like the Netscape 6 - version rather than the Opera 5 one..
		defineMagicVariable.call(opera, 'op5',function () { return 0; },null);
		defineMagicVariable.call(opera, 'ns6',function () { return 1; },null);

		// certain versions break if insertRule throws exceptions. Also see bug 242411.
		// Better fake missing support for DOM2Style then..
		defineMagicVariable.call(opera, 'um', function(o){ o.ss=false; return o; }, null);
    }





	// The required attribute does not take the value false according to WebForms2 - remove "required=false" from form elements
// Generic JS library patches
// Asia-region Generic Patches
			// 305669, The required attribute does not take the value false according to WebForms2 - remove "required=false" from form elements
	window.addEventListener('load', function(){
		try{var obj = document.evaluate( '//input[translate(@required, "FALSE", "false")="false"]', document.documentElement, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null ), el, i=0 ;
		while(el=obj.snapshotItem(i)){el.removeAttribute('required');i++;}}catch(e){}
	}, false);
			// 0, Generic JS library patches
	// Use an event listener to detect specific scripts
	opera.addEventListener( 'BeforeExternalScript', function(ev){
		match.call=replace.call=indexOf.call=toLowerCase.call=postError.call=addEventListener.call=removeEventListener.call=version.call=parseFloat.call=call;
		
		var name=ev.element.src; 
		if( !name ){ return; } // no fixes required for SCRIPT xlink:href so far..
		name=toLowerCase.call(name );// toLowerCase fixes sangjatten.se
	      if ( indexOf.call(name, 'dqm_')>-1 || indexOf.call(name, 'dnm_')>-1 || indexOf.call(name, 'cbrowser_opera.js')>-1 ){ 
			// OpenCube menu
			if(fixOpenCube(name)){
				postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (OpenCube fix). See browser.js for details.');
			}
			return;
	      }else if(  indexOf.call(name, 'hm_loader')>-1  ){ 
			// HierMenus menu
			// If we apply this fix to version 6.x the menu breaks.
			// HM support recommends checking that HM_BrowserVersion is not defined
			addEventListener.call(opera, 'BeforeScript', function(ev){ 
				match.call=removeEventListener.call=postError.call=call;
				if( ev.element.text && ! match.call(ev.element.text, /hm_browserversion/i) ){
					fixHierMenus(name);
					postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (HierMenus fix). See browser.js for details.');
				}
				removeEventListener.call(opera, 'BeforeScript', arguments.callee, false);
			}, false);
			return;
	      }else if(  indexOf.call(name, 'mmenu')>-1 || indexOf.call(name, 'milonic')>-1  ){ 
			// Milonic menu
			fixMilonicMenu(name);
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Milonic fix). See browser.js for details.');
			return;
		
	      }else if(  match.call(name, /menu\d*_(com|build|var|program|compact)\.js$/)   ){ 
			// HV menu
			fixHVMenu(name);
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (HVMenu fix). See browser.js for details.');
			return;
	      }else if(  match.call(name, /coolmenus\d?.js$/)   ){ 
			// coolmenus menu
			fixCoolmenus(name);
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Coolmenus fix). See browser.js for details.');
			return;
	      }else if(  match.call(name, /udm[_-]/)  || (  match.call(name, /(sniffer|control)\.js$/)   )    ){ 
			// UDM menu
			addEventListener.call(opera, 'BeforeScript', function(ev){
				match.call=postError.call=call;
				if( match.call(name, /udm[_-]/)  || indexOf.call(ev.element.text, 'UDM')>-1 || indexOf.call(ev.element.text, 'um.ov=um.ov.split(/opera[\\/ ]7./);um.ov=um.pi(um.ov[1].charAt(0));')>-1 ){
					fixUDM(name);
					postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (UDM fix). See browser.js for details.');
				}
			}, false);
			return;
	      }else if(  indexOf.call(name, 'dynapi/api/browser.js')>-1  || indexOf.call(name, 'dynlayer.js')>-1  ){
			navRestore['appName'] = navigator.appName;
			navigator.appName = 'Microsoft Internet Explorer';
			shouldRestore = true;
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (DynAPI fix). See browser.js for details.');
		}else if(  match.call(name, /stm(\d+|_menu).js$/)  ){
			fixSoThinkMenus();
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (SoThink fix). See browser.js for details.');
		}else if( indexOf.call(name, 'transmenu')>-1 ){
			fixTransmenus();
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Transmenu fix). See browser.js for details.');
		}else if( indexOf.call(name, 'xaramenu')>-1 ){
			addPreprocessHandler( new RegExp('if\\(navigator.userAgent.indexOf\\(\'Opera\'\\)!=-1\\)\\s*NS4=1;', ''), 'if(navigator.userAgent.indexOf(\'Opera\')!=-1){IE5=1;NS6=0;}');
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Xaramenu fix). See browser.js for details.');
		}else if(  indexOf.call(name, '/richtext.js')>-1  ){ // Bug 230549, bug 208097
			// Rich text editor checks for "On" where Opera and FireFox return "on". sigh. 
			addPreprocessHandler( 'designMode != "On"', 'designMode != "on"', true, function(t){indexOf.call=call;return indexOf.call(t.text, 'kevinroth.com')>-1;} );
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Rich text editor submit fix). See browser.js for details');
		}else if( parseFloat.call(window, version.call())<9.5 && indexOf.call(name, '/novell/webaccess/images/msglist.js')>-1){ // Bug 92454, workaround for NWA
			defineMagicFunction.call(opera, 'fixContentHeight',
				function(oF, oT){
					document.documentElement.clientHeight=window.innerHeight;
					oF.apply(oT, slice.call(arguments, 2));
			});
			postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Height function fix). See browser.js for details');
		}else if( indexOf.call(name, 'awmlib')>-1 ){
				opera.addEventListener('BeforeScript', fixLiknoAllWebMenus, false);
		}else if( indexOf.call( name, 'tiny_mce' )>-1 && 'designMode' in document){
			if( parseFloat.call(window, version.call())<9.5  ){
				postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (TinyMCE paste+enter fix). See browser.js for details');
				addEventListener.call( document, 'load', function(){
					for(var i=0,f;f=frames[i];i++){
						try{
							if( ! match.call(f.name, /^mce_editor/) )continue;
							(function(f){
								addEventListener.call(f.document, 'keypress', function(e){
									if(e.keyCode==13){
										var sel = f.getSelection();
										if( sel.anchorNode == f.document.documentElement ){
											var rng = sel.anchorNode.ownerDocument.createRange();
											rng.selectNodeContents(sel.anchorNode.ownerDocument.body);
											rng.collapse( true );
											sel.removeAllRanges();
											sel.addRange(rng);
										}
									}
								},true );
							})(f);
						}catch(e){}
					}
				}, false);
			}else{ // patches for 9.5 and up
				opera.addEventListener('BeforeScript', function(e){ // 335463, lines reversed on enter by workaround against old Opera bug
						if( e.element.text.match( /majorVersion\s*=\s*"2"/ ) || ( e.element.text.match( /majorVersion\s*:\s*'3'/ ) && e.element.text.match(/minorVersion\s*:\s*'(0|X)/) ) ){ /* 0|X because of CORE-15898*/
						postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (legacy TinyMCE enter fix + link button fix). See browser.js for details');
						e.element.text = e.element.text.replace( /if\s*\((tinyMCE\.|)isOpera\)\s*\{(\s*(\w{1,}\.normalize\(\);|)\s*\w{1,}\.insertNode\(\s*\w{1,}\s*\);)/g , 'if(false){$2' );
						opera.addEventListener('AfterEvent.DOMContentLoaded', function(){ // 345778, create link button not available
							if( typeof TinyMCE_Selection !='undefined' ){
								TinyMCE_Selection.prototype.getSelectedText=function(){return this.getSel().toString();};
							}
						},false);
					}
					opera.removeEventListener('BeforeScript', arguments.callee, false);
				},false);
				if( parseFloat.call(window, version.call(opera))==9.5  ){
					opera.addEventListener( // 336566, enabling designMode before using document.write will disable it again in the new document
						'BeforeEvent.load',
						function(e){
							var patch_is_required = true;
							if( typeof TinyMCE_Engine == 'undefined' ) return;
							try{
								if((new TinyMCE_Engine).majorVersion>=3){ // fix not required for versions 3 and above, remove event listener and quit
									patch_is_required=false;
								}
							}catch(e){}
							if( ! patch_is_required ){
								opera.removeEventListener('BeforeEvent.load', arguments.callee, false); return;
							}
								if(e.event.target && e.event.target.tagName && e.event.target.tagName.toUpperCase()=='IFRAME'){ // load event for IFRAME
								var iframe=e.event.target;
								if( iframe.id && iframe.id.match(/^mce_editor_\d/) && iframe.contentDocument ){
									iframe.contentDocument.designMode='on';
									postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (legacy TinyMCE document.write fix). See browser.js for details');
								}
							}
						},
						false
					);
				}
			}
			if( indexOf.call(name, 'tiny_mce_popup')!=-1 ){ // Working around a workaround for onload handling differences, 275267
				opera.defineMagicFunction('onLoadInit', function(func, thisObj){
					func.called=true;
					return func.call(thisObj);
				});
				addEventListener.call(window, 'load', function(){
					if( window.onLoadInit && ! onLoadInit.called ){
						setTimeout(onLoadInit, 100);
					}
				}, false );
			}
		}else if(indexOf.call(name, 'dev.virtualearth.net/mapcontrol/mapcontrol.ashx')>-1 && window.SVGDocument){
			navRestore.userAgent = navigator.userAgent;
			navigator.userAgent+='KHTML';//356736
			shouldRestore=true;
		}else if(indexOf.call(name,'s_code')>-1||indexOf.call(name,'omniture')>-1){//PATCH-59
			avoidDocumentWriteAbuse();
		}else if(indexOf.call(name,'setdomain.js')>-1){//PATCH-128
			navRestore.userAgent = navigator.userAgent;
			navigator.userAgent+=' Gecko';
			shouldRestore=true;
		}
		
		// Creating event handler to restore any changed navigator properties
		if( shouldRestore ){
			addEventListener.call(opera, 'AfterExternalScript', 
				function(ev){
					removeEventListener.call=call;
					var prop;
					for(prop in navRestore) navigator[prop]=navRestore[prop];
					removeEventListener.call(opera, 'AfterExternalScript', arguments.callee, false);
				}
			, false);
		}
	}, false);
			// 0, Asia-region Generic Patches
	opera.addEventListener('BeforeExternalScript',function(ev){
		var name=ev.element.src; 
		if(!name){return;}
		if((name.indexOf('http://api.e-map.ne.jp/jsapi.cgi')!=-1)&&(name.indexOf('zdccommon.js')!=-1)){
			// Zenrin Datacom E-Map API, PATCH-115
			Event.prototype.__defineGetter__('layerX',function(){ return this.offsetX; });
			Event.prototype.__defineGetter__('layerY',function(){ return this.offsetY; });
			
		}else if((name.indexOf('expapi/authentication')!=-1)||(name.indexOf('rosen/authentication')!=-1)){
			// Rosenzu ASP Map Service map, PATCH-122
			opera.defineMagicFunction('_ch',function(){return true;});
		}else if((name.indexOf('expapi/suggest')!=-1)||(name.indexOf('rosen/suggest')!=-1)){
			// Rosenzu ASP Map Service suggestions, PATCH-122
			opera.defineMagicFunction('checkBrowser',function(){return true;});
		}else if(name.indexOf('http://ebook.webcatalog.jp/engine/java/7net/common/sCommonLib.js')!=-1){ 
			// Netfly TrueEBook, PATCH-125
			opera.defineMagicFunction('funcGetBrowser',function(){return 2;}); 
		}
	},false);


	if((hostname=='www.opera.com' || hostname=='jp.opera.com') && pathname.indexOf('/docs/browserjs/')==0){			// 0, Browser.js status and version reported on browser.js documentation page
		document.addEventListener((parseFloat(opera.version())>9?'DOMContentLoaded':'load'),function(){
			if(document.getElementById('browserjs_active')){
				document.getElementById('browserjs_active').style.display='';
				document.getElementById('browserjs_active').getElementsByTagName('span')[0].appendChild(document.createTextNode(bjsversion));
				document.getElementById('browserjs_status_message').style.display='none';
			}else if(document.getElementById('browserjs_status_message')){
				document.getElementById('browserjs_status_message').firstChild.data='Browser.js is enabled! '+bjsversion;
			}
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Browser.js status and version reported on browser.js documentation page). See browser.js for details');
	} else if(hostname.indexOf('.aol.') >-1){			// 0, AOL
		/* AOL */
	
	
		if(hostname.indexOf('aol.com') >-1){			// 262693, AOL browser sniffing causes missing styling
			document.addEventListener('DOMContentLoaded', function(){document.documentElement.className='SAF';}, false);
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AOL browser sniffing causes missing styling). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (AOL). See browser.js for details');
	} else if(hostname.indexOf('.picsearch.com')>-1){			// PATCH-171, Avoid bug that breaks frameset on picsearch.com
		avoidMagicBodyCreation();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid bug that breaks frameset on picsearch.com). See browser.js for details');
	} else if(hostname.indexOf('.wimbledon.org')>-1){			// PATCH-171, Avoid bug that breaks frameset on wimbledon.org
		avoidMagicBodyCreation();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid bug that breaks frameset on wimbledon.org). See browser.js for details');
	} else if(hostname.indexOf('.yahoo.')>-1){			// 0, Yahoo!
		/* Yahoo! */
	
	
		if(hostname.indexOf('.mail.yahoo.')>-1&&(href.indexOf( '/dc/system_requirements?browser=blocked' )>-1||href.indexOf( '/dc/system_requirements?browser=unsupported' )>-1)){			// 194334, Y!Mail work around browser blocking
			location.href='/dc/launch?sysreq=ignore';
			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Y!Mail work around browser blocking). See browser.js for details');
		}
		if(hostname.indexOf('.mail.yahoo.')>=0 && pathname.indexOf('/dc/')==0){			// CORE-17538, Y!Mail avoid text selection on drag-and-drop
			window.addEventListener('mousedown', function(evt) {
				var target = evt.target;
				var cursor = getComputedStyle(target, null).cursor;
				if (/move/i.test(cursor) || /size/i.test(cursor)) {
					evt.preventDefault();
				} else if (!('value' in target) /* don't preventDefault for <input>, etc */) {
					for (var node = target; node; node = node.parentNode) {
						if (node.hasAttribute && node.hasAttribute('tabindex')) {
							evt.preventDefault();
							break;
						}
					}
				}
			}, true);
					// 321384, createElement in XML document should put un-prefixed nodes in null namespace
			var docCreateElement = Document.prototype.createElement;
			if( window.XMLDocument ){
				XMLDocument.prototype.createElement = function(n){ return n.indexOf(':')==-1 ? this.createElementNS(null, n) : docCreateElement.call(this,n); }
			}else{
				Document.prototype.createElement = function(n){ return n.indexOf(':')==-1 ? this.createElementNS(null, n) : docCreateElement.call(this,n); }
			}
					// 194334, Y!Mail preventing drag from selecting text
			if( self==top )
				opera.addEventListener('BeforeEventListener.mousedown',function(e){
						try{
							indexOf.call = preventDefault.call = call;
							if( indexOf.call(e.event.target.parentNode.parentNode.className, 'messageRow')>-1)
								preventDefault.call(e.event);
						}catch(e){}
				},false);
			
			document.addEventListener('mousemove',function(e){
				if( e.target.getAttribute('unselectable')=='on' )
					e.target.ownerDocument.defaultView.getSelection().removeAllRanges();
			},false);
			
					// 194334, Y!Mail remove selectSingleNode and selectNodes
			/* because Yahoo mail is better at emulating proprietary IE functions than we are.. */
			Node.prototype.selectSingleNode=undefined;
			Node.prototype.selectNodes=undefined;
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Y!Mail avoid text selection on drag-and-drop\ncreateElement in XML document should put un-prefixed n...). See browser.js for details');
		}
		if(hostname.indexOf('mail')==-1){			// 271238, Yahoo ISP portal blocks Opera users
			addPreprocessHandler( /d\.location\.href = ".*?\/browser_upgrade\.html";/g, '');
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Yahoo ISP portal blocks Opera users). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Yahoo!). See browser.js for details');
	} else if(hostname.indexOf('adf.ly')==0){			// PATCH-171, Avoid bug that breaks frameset on adf.ly
		avoidMagicBodyCreation();
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid bug that breaks frameset on adf.ly). See browser.js for details');
	} else if(hostname.indexOf('barnesandnoble.com')>-1){			// 195961, Barnes&Noble uses "required" attributes on elements that aren't required
		window.addEventListener('load', function(){var nodes=document.evaluate('//input[@required]', document.body,null,XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE,null),node=null,i=0; while(node=nodes.snapshotItem(i)){ node.removeAttribute('required'); i++; }},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Barnes&Noble uses "required" attributes on elements that aren\'t required). See browser.js for details');
	} else if(hostname.indexOf('bild.de')>-1){			// PATCH-205, Fix image gallery navigation
		addCssToDocument('.bdeFotoGalNavForw a:hover, .bdeFotoGalNavBack a:hover{background:inherit !important;}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix image gallery navigation). See browser.js for details');
	} else if(hostname.indexOf('blogger.com')>-1){			// 177059, Blogger: browser detection prevents WYSIWYG editing
		navigator.product = 'Gecko';
		navigator.userAgent = navigator.userAgent.replace(/Opera/, 'Firefox')+' ( rv:1.9.0.3)';
		
		opera.defineMagicVariable(
			'Detect',
			function( obj ){return obj;},
			function( obj ){
				obj.OPERA = function(){return false;}
				obj.MOZILLA = function(){return true;}
				obj.IE=function(){return false;}
				obj.IE_5_5_newer=function(){return false;}
				return obj;
			}
		);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Blogger: browser detection prevents WYSIWYG editing). See browser.js for details');
	} else if(hostname.indexOf('china-pub.com')>-1){			// CORE-21773, Work around window.event getter bug
		opera.defineMagicFunction('src', function( func,realThis, ev ){
			try{
				var returnValue=func.apply(realThis, arguments.slice(2));
			}catch(e){
				if( ev && ev.target && returnValue==undefined )return ev.target;
			}
			return returnValue;
		});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Work around window.event getter bug). See browser.js for details');
	} else if(hostname.indexOf('ebay')>-1){			// 0, eBay
		/* eBay issues */
	
	
		// Avoid IFRAME resize causing lots of empty space on auctions
				// PATCH-195, Avoid IFRAME resize causing lots of empty space on auctions
		function resizeIframesAndPassSizeOn(e){
			if(e && e.type==='message' && e.origin.indexOf('ebaydesc')>-1){
				for(var iframes=document.getElementsByTagName('iframe'),iframe,i=0;iframe=iframes[i];i++){
					if(iframe.src.indexOf(e.origin)>-1){
						iframe.style.height=(20+parseInt(e.data))+'px';
					}
				}
			}
			if(top!=self)parent.postMessage(document.documentElement.scrollHeight, '*');
		}
		window.addEventListener('message', resizeIframesAndPassSizeOn, false);
		
	
	
		if(hostname.indexOf('.ebaydesc.')>-1){			// PATCH-195, Avoid IFRAME resize causing lots of empty space on auctions (the IFRAME part)
			window.addEventListener('load', function(){ 
				setTimeout(function(){
					if(top!=self)parent.postMessage(document.documentElement.scrollHeight, '*');
				}, 100); 
			}, false);
			
				if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Avoid IFRAME resize causing lots of empty space on auctions (the IFRAME part)). See browser.js for details');
		}
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (eBay). See browser.js for details');
	} else if(hostname.indexOf('enter.nifmail.jp') > -1){			// OTW-4878, Nifmail web mail bypass browser blocking
		opera.defineMagicFunction('checkBrowser',function(){
			return 1;
		},false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Nifmail web mail bypass browser blocking). See browser.js for details');
	} else if(hostname.indexOf('forums.xbox.com')>-1){			// PATCH-193, No scrollbars on XBox forum
		addCssToDocument('body,html{height:auto!important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (No scrollbars on XBox forum). See browser.js for details');
	} else if(hostname.indexOf('geoaccess.com')!=-1){			// 318050,  BlueCross browser sniffing prevents insurance search
		opera.defineMagicVariable('is_nav', function(){return true;}, null);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( BlueCross browser sniffing prevents insurance search). See browser.js for details');
	} else if(hostname.indexOf('isbank.com.tr')>-1){			// 265077,  fixing navigation menu on isbank.com.tr
		opera.addEventListener('BeforeScript', function(e){ replace.call=call; e.element.text=replace.call(e.element.text, 'SaklaGoster(sFrameAdi, 0, i.sMenuAd);};else if', 'SaklaGoster(sFrameAdi, 0, i.sMenuAd);}else if') },false);
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( fixing navigation menu on isbank.com.tr). See browser.js for details');
	} else if(hostname.indexOf('mail.live.com')!=-1){			// CORE-17444, Fix drag and drop in Hotmail
		function fixButton(e) {
			if (e.button == 1) {
				e.__defineGetter__('button', function() { return 0 });
			}
		};
		window.addEventListener('mousedown', fixButton, true);
		window.addEventListener('mousemove', fixButton, true);
		window.addEventListener('mouseup', fixButton, true);
		
				// PATCH-192, Closing already closed documents from timeout can hang ES execution
		opera.defineMagicVariable('_dapUtils', function(obj){ obj.is_ff_closeIfrm=false; return obj; }, null);
				// CORE-17447, Mispositioned sprites due to missing CSS
		addCssToDocument('.c_is { display: inline-block }');
				// CORE-17445, Detecting style.filter causes missing opacity effects
		CSSStyleDeclaration.prototype.__defineGetter__('filter', function() {
			return undefined;
		});
				// CORE-17446, Borders on folders remain after dragging things past them
		var styleDec = (document.documentElement) ? document.documentElement.style : null;
		if(styleDec){
			var getBorderColor = styleDec.__lookupGetter__('borderColor');
			var setBorderColor = styleDec.__lookupSetter__('borderColor');
			CSSStyleDeclaration.prototype.__defineGetter__('borderColor', function() {
				if (parseFloat(this.borderWidth, 10)) {
					return getBorderColor.apply(this, arguments);
				}
				return '';
			});
			CSSStyleDeclaration.prototype.__defineSetter__('borderColor', setBorderColor);
		}
				// CORE-17497, Opera doesn't support col-resize/row-resize cursors.
		addCssToDocument('html .SplitterBarH { cursor: s-resize } html .SplitterBarV { cursor: e-resize } #masterSplitter { cursor: e-resize }');
				// CORE-17500, Identify as Opera to the client-side sniffer
		if (!/EditMessageLight/.test(location.pathname)) {
			var browser = undefined;
			window.__defineGetter__('Browser', function() {
				return browser;
			});
			window.__defineSetter__('Browser', function(v) {
				browser = v;
				if (browser) {
					delete browser.isFF;
					delete browser.isFF2;
					delete browser.isFF3;
				}
				return browser;
			});
		}
		
		// Restore Opera UA string (we mask as Firefox to get the correct code over HTTP)
		var stuff = navigator.userAgent.split('(')[1].split(')')[0].split(';');
		stuff.pop();
		navigator.userAgent = 'Opera/' + opera.version() + ' (' +
				stuff.join(';') + ') Presto/' +
				(parseFloat(opera.version()) < 10 ? '2.1' : '2.2');
				// PATCH-37, To-button does not bring up contacts list
		window.getComputedStyle=function(){
			var result=getComputedStyle.apply(this, arguments);
			if( /ContactPicker/.test(arguments[0].id )){
				result.__defineGetter__('height', function(){return '300px'});
			}
			return result;
		}
		
				// PATCH-107, Fixes downloading attachments in Hotmail for O10.
		HTMLAnchorElement.prototype.getAttribute= function(n){
		if( n=='aNewWin' && getAttribute.call(this, 'aIdx')!=null )return 'true';
			return getAttribute.call(this,n);
		}
		var window_open=window.open;
		window.open=function(){
			if( /ScanAttachment\.aspx/.test(arguments[0]) ){
				var url=arguments[0];
				arguments[0]='';
			}
			var w=window_open.apply(this, arguments);
			if(url){
				w.location.href='data:text/html,'+encodeURIComponent('<html><head></head><body><p style="text-align:center; margin-top: 100px">Downloading attachment...<br><a href="javascript:window.close()">Close window</a></p></body></html>');
				setTimeout(function(){w.location.href=url},1);
			}
			return w;
		}
				// DSK-235885, Hotmail uses lookupGetter on prototypes, not instances
		var styleSetterLookupMethod = document.createElement('span').style.__lookupSetter__;
		 CSSStyleDeclaration.prototype.__lookupSetter__ = function(prop){
			return styleSetterLookupMethod.call(document.createElement('span').style, prop);
		 };
				// PATCH-135, Fixes removing contacts from To field by clicking small X icon
		addCssToDocument('.ContactPicker_AutoComplete img{position:static!important;}');
				// PATCH-149, Delay load event for compose IFRAME if it's not accessible yet, enables editing
		opera.addEventListener('BeforeEventListener.load', function(e){
			var target=e.event.target;
			if(target.tagName=='IFRAME' && target.src.indexOf(location.hostname)>-1 && target.src.indexOf(location.hostname)<target.src.indexOf('/', 8)){ 
				var delayLoadEvent=false;
				try{
					target.contentWindow.document.body;
				}catch(e){
					delayLoadEvent=true;
				}
				if(delayLoadEvent){
					e.preventDefault();
					var interval=setInterval( function(){
						try{
							target.contentWindow.document.body;
							e.listener.call(target, e.event);
							clearInterval(interval);
						}catch(e){}
					}, 200 );
				}
			}
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Fix drag and drop in Hotmail\nClosing already closed documents from timeout can hang ES execution\nM...). See browser.js for details');
	} else if(hostname.indexOf('msnbc.com')>-1){			// 207178, MSNBC sniffing hides Flash content
		opera.defineMagicVariable('oSniff', function(o){return o;},function(){ window['oSniff'].nn=5; });
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (MSNBC sniffing hides Flash content). See browser.js for details');
	} else if(hostname.indexOf('namooya.com')>-1){			// 241286, Namooya.com main flash does not appear
		document.attachEvent=undefined;
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Namooya.com main flash does not appear). See browser.js for details');
	} else if(hostname.indexOf('news.qq.com')>-1){			// PATCH-112, weather.news.qq.com expects getElementById() to find named elements
		var gEBI=document.getElementById;
		document.getElementById=function(){
			var result=gEBI.apply(this, arguments);
			if(!result)result=document.getElementsByName.apply(this,arguments)[0];
			return result;
		}
				// PATCH-112, weather.news.qq.com uses document.all for browser detection
		opera.defineMagicVariable('ie4',function(){return true;}, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (weather.news.qq.com expects getElementById() to find named elements\nweather.news.qq.com uses docume...). See browser.js for details');
	} else if(hostname.indexOf('picasaweb.google')!=-1){			// PATCH-98, Hidden links and image details due to a CSS height property
		addCssToDocument('.lhcl_hideoverflow{ height:auto!important }');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Hidden links and image details due to a CSS height property). See browser.js for details');
	} else if(hostname.indexOf('qxl.dk')>-1){			// ITVSDK-3669, Spatnav needs href attribute to find menu elements on qxl.dk
		window.addEventListener('load', function() { 
		    snapshot = document.evaluate('//a[not(@href)]', document, null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null); 
		    for(i=0;i<snapshot.snapshotLength;i++){ 
		        snapshot.snapshotItem(i).setAttribute('href','') 
		    } 
		}, false);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Spatnav needs href attribute to find menu elements on qxl.dk). See browser.js for details');
	} else if(hostname.indexOf('social.microsoft.com')>-1){			// PATCH-203, Microsoft forums editor hangs
		addPreprocessHandler(/(if\(tinymce\.relaxedDomain\)t\.iframeHTML\+='<script\s*type="text\/javascript">document\.domain\s*=\s*"'\+tinymce\.relaxedDomain\+'";<\/script>';|ed\.setupIframe\(\);)/g, '', true, function(el){return(el.src && indexOf.call(el.src, 'tiny_mce.js')>-1) });
		
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Microsoft forums editor hangs). See browser.js for details');
	} else if(hostname.indexOf('stylenanda.co.kr')>-1){			// PATCH-156, Clicks blocked on stylenanda.co.kr
		opera.defineMagicFunction('click', function (oFun, oThis){ return true; } );
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Clicks blocked on stylenanda.co.kr). See browser.js for details');
	} else if(hostname.indexOf('sytadin.fr')!=-1){			// 365351, Sytadin.fr IFRAME resize script detects Opera
		fixIFrameSSIscriptII('resizeIframeOnContent');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Sytadin.fr IFRAME resize script detects Opera). See browser.js for details');
	} else if(hostname.indexOf('viddler.com')>-1){			// PATCH-80, Prevent re-execution of scripts on viddler.com
		if(HTMLScriptElement.prototype.__defineGetter__)HTMLScriptElement.prototype.__defineGetter__('childNodes', function(){return []});
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Prevent re-execution of scripts on viddler.com). See browser.js for details');
	} else if(hostname.indexOf('westjet.com')>-1 ){			// 270752,  Westjet browser sniffing causes reload loop
		opera.defineMagicVariable('browser', function(o){ o.isSupported=true; return o; }, null);
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' ( Westjet browser sniffing causes reload loop). See browser.js for details');
	} else if(hostname.indexOf('www.hongen.com') >-1){			// PATCH-187, make links clickable
		addCssToDocument('#SL_ScrBox_1{display:none !important}');
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (make links clickable). See browser.js for details');
	} else if(href.indexOf('/sample_lr.html')>-1){			// PATCH-128, Sun Webmail fails to set document.domain due to browser sniffing
		navigator.userAgent+=' Gecko';
			if(self==top)postError.call(opera, 'Opera has modified the JavaScript on '+hostname+' (Sun Webmail fails to set document.domain due to browser sniffing). See browser.js for details');
	}

})(opera);
